/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArcParticleTypeData
implements ParticleOptions {
    private ParticleType<ArcParticleTypeData> type;
    public Vec3 source;
    public Vec3 target;
    static final ParticleOptions.Deserializer<ArcParticleTypeData> DESERIALIZER = new ParticleOptions.Deserializer<ArcParticleTypeData>(){

        public ArcParticleTypeData fromCommand(ParticleType<ArcParticleTypeData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ArcParticleTypeData(type, ArcParticleTypeData.deseralizeVec(reader.readString()), ArcParticleTypeData.deseralizeVec(reader.readString()));
        }

        public ArcParticleTypeData fromNetwork(ParticleType<ArcParticleTypeData> type, FriendlyByteBuf buffer) {
            return new ArcParticleTypeData(type, ArcParticleTypeData.deseralizeVec(buffer.m_130277_()), ArcParticleTypeData.deseralizeVec(buffer.m_130277_()));
        }
    };

    public ArcParticleTypeData(ParticleType<ArcParticleTypeData> particleTypeData, Vec3 source, Vec3 target) {
        this.type = particleTypeData;
        this.source = source;
        this.target = target;
    }

    public ParticleType<ArcParticleTypeData> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(this.serializeVec(this.target));
        packetBuffer.m_130070_(this.serializeVec(this.source));
    }

    public String m_5942_() {
        return this.type.getRegistryName().toString() + " " + this.serializeVec(this.target) + " " + this.serializeVec(this.source);
    }

    public String serializeVec(Vec3 vec3d) {
        return vec3d.f_82479_ + "," + vec3d.f_82480_ + "," + vec3d.f_82481_;
    }

    public static Vec3 deseralizeVec(String string) {
        String[] arr = string.split(",");
        return new Vec3(Double.parseDouble(arr[0].trim()), Double.parseDouble(arr[1].trim()), Double.parseDouble(arr[2].trim()));
    }
}

